function project_mgr_init_ix_for_check_model(fig)
% initialize index for check model.
% [USAGE]
%    project_mgr_init_ix_for_check_model(<fig>);
% [IN]
%    fig : figure handle of project_mgr gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handles is specified.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);

% rememeber index of last selected parameter.
data.parm_ix_for_check_model = zeros(3, 1); % ix 1: last selected brain_parm
                                            %    2: last selected fmri_parm
                                            %    3: last selected meg_parm
% save data
guidata(fig, data);
