function [data, new_name] = project_mgr_builder_copy(data)
% Copy batch builder
% [USAGE]
%    [data] = project_mgr_builder_copy(data);
% [IN]
%        data : project_mgr data
% [OUT]
%        data : project_mgr data(updated)
%    new_name : copied builder name
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is specified.');
end

%
% --- Main Procedure
%
H = data.H;

Nbuilders   = length(data.batch_builders);
% get selected batch builder
idx = get(H.builder_popup, 'Value');
% copy instance
cbuilder = data.batch_builders{idx};
name        = vb_batch_mgr_get_name(cbuilder);
% change name
new_name    = ['copied ' name];
cbuilder    = vb_batch_mgr_set_name(cbuilder, new_name);
data.batch_builders{Nbuilders+1, 1} = cbuilder;

% Save builders to file
batch_builders = data.batch_builders;
result = vb_save(data.project_file, 'batch_builders');


%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
