function [result, errmsg] = project_mgr_builder_close(bmgr)
% This is called by external object.
% Close batch builder gui.
% [USAGE]
%    project_mgr_builder_close(<bmgr>);
% [IN]
%      bmgr : vb_batch_mgr object.
%             if this is empty, user selected "Don't save'.
% [OUT]
%    result : SUCCESS or FAILURE
%    errmsg : error reason
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('bmgr', 'var')
    error('bmgr is a required parameter.');
end

%
% --- Main Procedure
%

% find project_mgr figure handle
current_hidden_state = get(0, 'ShowHiddenHandles');
set(0, 'ShowHiddenHandles', 'on');
pmgr = findobj('Tag', 'project_mgr');
set(0, 'ShowHiddenHandles', current_hidden_state);
if isempty(pmgr) || ~ishandle(pmgr)
    error('project_mgr cannot be found.');
end

% load data
data = guidata(pmgr);

H = data.H;

result = SUCCESS;
errmsg = '';

if ~isempty(bmgr)
    % save batch builder.
    idx = get(H.builder_popup, 'Value');
    data.batch_builders{idx, 1} = bmgr;

    % save file
    batch_builders = data.batch_builders;
    try
        vb_save(data.project_file, 'batch_builders');
    catch
        result = FAILURE;
        err = lasterror;
        errmsg = err.message;
        return;
    end
end

% GUI state enable
set(H.builder_popup, 'Enable', 'on');
set(H.open_builder_push, 'Enable', 'on');

data.batch_fig = -1;

% save data
guidata(pmgr, data);

%
%
% update builder list
project_mgr_view_update_builders(pmgr);
