function [varargout] = pa_yokogawa_meg_util(fig, command, parm)
% This function is subcontracting function of yokogawa meg gui.
% [IN]
%        fig : figure handle of yokogawa meg gui.
%    command : utility type
%       parm : other parameters
% [OUT]
%    varargout{n}: return value
%        @command : 'get_eeg_gain' ==> gain
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure was specified.');
end
if ~exist('command', 'var') || isempty(command)
    error('invalid command was specified.');
end

%
% --- Main Procedure
%

% load data(@see pa_yokogawa_meg_create)
data = guidata(fig);

switch(command)
    case 'update_output_fname'
        update_output_fname(data.H, data.output_filename);
    case 'update_exec_push_status'
        update_exec_push_status(data.H);
    case 'exec_meg'
        exec_meg(data);
    case 'reset_parameter'
        reset_parameter(data);
end

% save data
guidata(fig, data);

function update_output_fname(H, output_filename)
% This function makes output filename and sets filename to GUI.
% [IN]
%                  H : GUI component handles
%    output_filename : output filename
% [OUT]
%    none

    global vbmeg_inst;
    define = vbmeg_inst.const;

    filename = get(H.meg_file_edit, 'String');
    [fpath, fname, fext] = vb_get_file_parts(filename);

    if ~isempty(output_filename)
        fname = output_filename;
    end
    
    % save directory
    save_dir = get(H.save_dir_edit, 'String');

    % save_dir/yokogawa_filename.meg.mat
    megmatfname = [save_dir filesep fname, define.MEG2_EXTENSION];
    set(H.megmat_file_edit, 'String', megmatfname);
    
    % binary datadir name
    bin_dir = vb_device_make_data_dir(megmatfname, 0);
    if length(bin_dir) >= 2 && ...
       (strcmp(bin_dir(1:2), './') || strcmp(bin_dir(1:2), '.\'))
       bin_dir = fullfile(save_dir, bin_dir(3:end));
    end
    set(H.binary_dir_edit, 'String', bin_dir);
    
    update_exec_push_status(H);

function update_exec_push_status(H)
% This function changes Exec button status.(clickable or not)
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    if ~isempty(get(H.meg_file_edit, 'String')) && ...
       ~isempty(get(H.save_dir_edit, 'String'))
        set(H.exec_push, 'Enable', 'on');
    else
        set(H.exec_push, 'Enable', 'off');
    end

function H = exec_meg(data)
% This function execute vb_job_meg with set parameter.
% [IN]
%    data : data of yokogawa meg gui(@see pa_yokogawa_meg_create)
% [OUT]
%    none

    H = data.H; % component handles

    %%%%%%%%%%%%%%%%%%%%
    % Parameter setting
    %%%%%%%%%%%%%%%%%%%%

    % project root directory
    proj_root = get(H.project_root_edit, 'String');

    save_dir   = get(H.save_dir_edit, 'String');
    binary_dir  = get(H.binary_dir_edit, 'String');
    
    % advanced parameters are set here.
    meg_parm = data.yokogawa_meg_parm;

    % data file
    meg_parm.yokogawa_file = get(H.meg_file_edit, 'String');

    % device
    meg_parm.device   = 'YOKOGAWA'; 

    % position file
    meg_parm.pos_file = get(H.position_file_edit, 'String');
    
    % Ext channel gain is already set @
    % pa_yokogawa_meg_edit_extra_channel_gain()

    % MEG-MAT file(output)
    meg_parm.meg_file = get(H.megmat_file_edit, 'String');

    %%%%%%%%%%%%%%%%%%%%
    % execute job
    %%%%%%%%%%%%%%%%%%%%
    str = get(H.exec_push, 'String');
    set(H.exec_push, 'String', 'Processing...');
    pause(0.01); % for update button string

    vb_job_meg(proj_root, meg_parm);

    set(H.exec_push, 'String', 'Exec');

function data = reset_parameter(data)
% This function resets yokogawa meg GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    H = data.H;

    % clear eeg_gain information
    data.yokogawa_meg_parm.eeg_gain = [];
    guidata(data.H.figure, data);

    meg_parm = vb_set_yokogawa_meg_parm;
    pa_yokogawa_meg_set_parm(H.figure, meg_parm);
    data = guidata(H.figure);
