function [dirname, canceled] = pa_prjdir_select(proj_root)
% directory select dialog 
%
% [IN]  proj_root : project root directory.
%
% [OUT] dirname   : relative directory name from proj_root
%       canceled  : true/false (true means dialog closed by cancel)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

canceled = false;

dirname = dir_dialog(proj_root, false);

% ѥproj_rootХѥˤ
if dirname ~= 0 & ~isempty(proj_root)
    dirname = vb_relativepath(dirname, proj_root);
    dirname = dirname(1:length(dirname)-1);
else
    canceled = true;
end

