function pa_sbi_meg_util(fig, command)
% This function is subcontracting function of sbi_meg GUI.
% [USAGE]
%    pa_sbi_meg_util(<fig>, <command>)
% [IN]
%        fig : figure handle of leadfield gui.
%    command : utility type
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure was specified.');
end
if ~exist('command', 'var') || isempty(command)
    error('invalid command was specified.');
end

%
% --- Main Procedure
%
% load data(@see pa_sbi_meg_create)
data = guidata(fig);

switch(command)
    case 'update_output_fname'
        update_output_fname(data.H);
    case 'update_exec_push_status'
        update_exec_push_status(data.H);
    case 'exec_meg'
        exec_meg(data);
    case 'reset_parameter'
        reset_parameter(data.H);
end

% save data
guidata(fig, data);

function update_output_fname(H)
% This function makes output filename and sets filename to GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none
    global vbmeg_inst;
    define = vbmeg_inst.const;

    fname = get(H.sbi_file_edit, 'String');
%    [path, name, ext] = fileparts(fname);
    [fpath, fname, fext] = vb_get_file_parts(fname);

    keyword = get(H.keyword_edit, 'String');
    if length(keyword) ~= 0
        sep = '_';
    else
        sep = [];
    end


    % save directory
    save_dir = get(H.save_dir_edit, 'String');

    % save_dir/sbi_filename.meg.mat
    megmatfname = [save_dir filesep fname, sep, keyword, define.MEG2_EXTENSION];
    
    set(H.megmat_file_edit, 'String', megmatfname);
    update_exec_push_status(H);

function update_exec_push_status(H)
% This function changes Exec button status.(clickable or not)
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    if ~isempty(get(H.sbi_file_edit, 'String')) & ...
       ~isempty(get(H.Dicom_file_edit, 'String')) & ...
       ~isempty(get(H.megmat_file_edit, 'String'))
        set(H.meg_exec_push, 'Enable', 'on');
    else
        set(H.meg_exec_push, 'Enable', 'off');
    end

function exec_meg(data)
% This function execute vb_job_meg with set parameter.
% [IN]
%    H : GUI component handles
% [OUT]
%    H : GUI component handles

    H = data.H; % component handles
    %%%%%%%%%%%%%%%%%%%%
    % Parameter setting
    %%%%%%%%%%%%%%%%%%%%

    % project root directory
    proj_root = get(H.prjroot_edit, 'String');

    % advanced parameters are set here.
    meg_parm = data.sbi_meg_parm;

    % SBI file
    meg_parm.sbi_file = get(H.sbi_file_edit, 'String');

    % device
    meg_parm.device   = 'SBI';

    % DICOM file
    dicom_str = get(H.Dicom_file_edit, 'String');
%    [path, name, ext] = fileparts(dicom_str);
    [fpath, fname, fext] = vb_get_file_parts(dicom_str);
    meg_parm.dicom_dir  = [fpath filesep];
    meg_parm.dicom_file = [fname fext];
    
    % Analyze file
    meg_parm.analyze_file = get(H.analyze_edit, 'String');
    
    % MEG-MAT file(output)
    meg_parm.meg_file = get(H.megmat_file_edit, 'String');

    % keyword
    meg_parm.keyword = get(H.keyword_edit, 'String');

    % comment
    meg_parm.comment = get(H.comment_edit, 'String');

    %%%%%%%%%%%%%%%%%%%%
    % execute job
    %%%%%%%%%%%%%%%%%%%%
    str = get(H.meg_exec_push, 'String');
    set(H.meg_exec_push, 'String', 'Processing...');
    pause(0.01); % for update button string

    vb_job_meg(proj_root, meg_parm);

    set(H.meg_exec_push, 'String', str);

function reset_parameter(H)
% This function resets brain GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    set(H.analyze_edit, 'String', '');
    set(H.sbi_file_edit, 'String', '');
    set(H.Dicom_file_edit, 'String', '');
    set(H.keyword_edit, 'String', '');
    set(H.comment_edit, 'String', '');
    set(H.save_dir_edit, 'String', '');
    set(H.megmat_file_edit, 'String', '');
