function [obj] = vb_timeseries_viewer_specify_display_time(obj)
% Display specified time point.
% [USAGE]
%    [obj] = timeseriesviewer_specify_display_time(obj);
% [IN]
%    obj : vb_timeseries_viewer object.
% [OUT]
%    obj : vb_timeseries_viewer object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

H = obj.H;
time = str2double(get(H.timepoint_current_text, 'String'));
if isnan(time)
    errordlg('Invalid time were specified.', 'Display time');
    range = xlim(H.data_axes);
    center = range(2) - range(1) / 2;
    set(H.timepoint_current_text, 'String', num2str(center,3));
    [obj] = vb_timeseries_viewer_update_display_time_range(obj);
    return;
end


Nsample = obj.Nsample;
freq    = obj.freq;
max_sec  = Nsample/freq;

% Display area
% 0s                     max_sec
%  |---|----------------|---|
%      |<--- 0 to 1 --->|
%    A         B          C
%  0 = window_len/2
%  1 = max_sec - window_len/2

B_start = obj.window_len / 2;
B_end   = max_sec - obj.window_len/2;


if time > B_end
    % C
    slider_val = 1;
elseif time < B_start
    % A
    slider_val = 0;
else
    % B
    B_len = B_end - B_start;
    if B_len == 0
        slider_val = 0;
    else
        slider_val = (time - B_start) / B_len;
    end
end

set(H.timeseries_slider, 'Value', slider_val);
obj = vb_timeseries_viewer_callback(obj, H.timeseries_slider);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
