function [obj] = vb_timeseries_viewer_plot_trial(obj, window_from, window_to)
% plot trial on timeseries data.
% [USAGE]
%    [obj] = vb_timeseries_viewer_plot_trial(obj);
% [IN]
%    obj : vb_timeseries_viewer object
% [OUT]
%    obj : updated vb_timeseries_viewer object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%
H = obj.H;
trig_yinfo = ylim(H.data_axes) * 0.98;

try
    % remove previous plot
    handles = [obj.trial_range_handles; 
               obj.trial_onset_handles;
               obj.ext_onset_handles];

    valid_ix = find(ishandle(handles) == 1);
    if ~isempty(valid_ix)
        delete(handles(valid_ix));
    end
catch
end
obj.trial_range_handles = [];
obj.trial_onset_handles = [];
obj.ext_onset_handles   = [];

% plot onset
data_yinfo = ylim(H.data_axes);
trig_yinfo = ylim(H.trigger_axes);

% Check trial number in display timewindow.
t_index = [];
for k=1:length(obj.trial_list)
    t = obj.trial_list(k);
    if (t.to >=  window_from && t.to <= window_to) || ...
       (t.from >= window_from && t.to <= window_to) || ...
       (t.from >= window_from && t.from <= window_to) || ...
       (t.from <= window_from && t.to >= window_to)
      
       t_index = [t_index; k];
    end
end

set(0, 'CurrentFigure', obj.figure);
set(obj.figure, 'CurrentAxes', H.data_axes);
for k=1:length(t_index)
    t = obj.trial_list(t_index(k));
    % trial(horizontal short lines)
    if t.invalid
        trial_bar_col = [0, 0, 0];
    else
        trial_bar_col = get(H.trial_color_axes, 'Color');
    end
    y = data_yinfo(1) + (mod(t_index(k)-1, 4)+1)*(data_yinfo(2)-data_yinfo(1))/30;
    hold on;
    
    t_h = plot([t.from, t.to], [y, y], ...
               'Color', trial_bar_col, 'LineWidth', 5);
    click_on_trial = 'vb_timeseries_viewer_trial_click(gcf, gcbo)';
    set(t_h, 'ButtonDownFcn', click_on_trial);
    setappdata(t_h, 'trialNum', t_index(k));
    obj.trial_range_handles = [obj.trial_range_handles; t_h];

    % onset(red vertical lines)
    if t.invalid, continue; end
    obj.trial_onset_handles = [obj.trial_onset_handles; ...
                                   plot([t.onset, t.onset], ...
                                     [data_yinfo(1), data_yinfo(2)], ...
                                     'r', 'LineWidth', 1)];
    set(obj.trial_onset_handles(end), 'HitTest', 'off');
end
set(obj.figure, 'CurrentAxes', H.trigger_axes);
for k=1:length(t_index)
    t = obj.trial_list(t_index(k));
    if t.invalid, continue; end

    % onset on trigger axes(red vertical lines)
    hold on;
    obj.ext_onset_handles =   [obj.ext_onset_handles; ...
                               plot([t.onset, t.onset], ...
                                    [trig_yinfo(1), trig_yinfo(2)], ...
                                    'r', 'LineWidth', 1)];
end


% Trial explanation
group = [obj.H.trial_explain_axes;
         obj.H.trial_explain_text;
         obj.H.trial_color_axes;
         obj.H.trigger_explain_axes;
         obj.H.trigger_explain_text];
if isempty(obj.trial_list)
    set(group, 'Visible', 'off');
else
    set(group, 'Visible', 'on');
end
%
% --- After check
%
if nargout ~= 1
    error('you should receive updated vb_timeseries_viewer object.');
end
