function vb_meg_viewer(meg_file, arg1)
% Launch MEG/EEG data viewer.
% 
% [Usage]
%    MEG/EEG trial data file.
%     * vb_meg_viewer(meg_file)
%    MEG/EEG continous data file 
%     * View MEG/EEG data with all external channels.
%       vb_meg_viewer(meg_file);
%     * View MEG/EEG data and external channel.
%       vb_meg_viewer(meg_file, external_ch);
%     * View MEG/EEG data and the trigger specified by trigger_file(.trig.mat).
%       vb_meg_viewer(meg_file, trig_file);
%
% [Input]
%       meg_file : VBMEG MEG/EEG file(.meg.mat/.eeg.mat)       [string]
%  * Listed below are parameters for MEG/EEG continuous file.
%       arg1 : = (optional) trigger file(.trig.mat)            [string]
%            : = (optional) external channel list.             {Nx1} or {1xN}
%                           if not specified, all the external
%                           channel will be displayed.

%
% --- Previous check
%
if ~exist('meg_file', 'var')
    eval(['help ' mfilename]);
end

% MEG/EEG file check
if exist(meg_file, 'file') ~= 2
    error('Specified MEG/EEG file not found.');
end

% Trigger channel
if ~exist('arg1', 'var')
    arg1 = [];
end

trig_extension = '.trig.mat';
if isempty(arg1)
    % MEG/EEG file is specified.
    trigger_file = '';
    trigger_ch = cell(0);
elseif ischar(arg1) && ...
       (length(trig_extension) < length(arg1)) && ...
       (strcmp(arg1(end-length(trig_extension)+1:end), trig_extension))
    % MEG/EEG file and trigger file are specified.
    trigger_file = arg1;
    trigger_ch   = cell(0);
else
    % MEG/EEG file and channel name are specified.
    trigger_file = '';
    trigger_ch   = arg1;
    
    if ischar(trigger_ch)
        trigger_ch = {trigger_ch};
    end
end

% Trigger channel
meg_info = vb_load_meg_info(meg_file);
if isempty(trigger_ch)
    % load MEG/EEG extra channel info
    ch_info_ext = vb_load_channel_info(meg_file, 'EXTRA');

    % Find External channel
    if strcmpi(meg_info.device, 'YOKOGAWA')
        ext_ix  = find(ch_info_ext.Type == -1); % -1 : Trigger channel
        trigger_ch = ch_info_ext.Name(ext_ix);
    else
        ext_ix  = find(ch_info_ext.Type ~= 0); % Except for null channnel
        trigger_ch = ch_info_ext.Name(ext_ix);
    end
end

%
% --- Main Procedure
%
if meg_info.Nrepeat == 1 && (isempty(vb_meginfo_get_pre_trigger(meg_info)) ||...
                             vb_meginfo_get_pre_trigger(meg_info) == 0)
    %
    % --- Continuous format
    %

    % load MEG/EEG data channel info
    ch_info     = vb_load_channel_info(meg_file);
    % launch continuous file viewer
    vb_timeseries_viewer_new(meg_file, 30, ch_info.Name, [], trigger_ch, trigger_file);
else
    %
    % --- Trial format
    %
    job_plot_meg(meg_file);
end
