function [obj] = vb_voice_trigger_new(ch_name, ...
                                   status_level, t_period, ...
                                   p_val, t_smooth)
% Create voice trigger.
%
% [USAGE]
%    vb_voice_trigger_new(ch_name, status_level, t_period, p_val, t_smooth);
% [IN]
%         ch_name : extract trigger from this channel [string]
%    status_level : factor for amplitude threshold. <optional>
%        t_period : <optional>
%           p_val : <optional>
%        t_smooth : <optional>
% [OUT]
%           obj : voice_trigger object
% [see also]
%    vb_get_voise_onset
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 1
    error('This function needs 1 argments. Please check your code.');
end

%
% --- Main Procedure
%
if ~exist('status_level', 'var')
    status_level = [];
end
obj = vb_trigger_new(ch_name, 'voice', status_level);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAMETER NAME IS IMPORTANT(for vb_get_trial_index)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist('t_period', 'var')
    obj.t_period = t_period;
end
if exist('p_val', 'var')
    obj.p_val    = p_val;
end
if exist('t_smooth', 'var')
    obj.t_smooth = t_smooth;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
