function [obj] = vb_trial_new(from, to, onset)
% Create trial object.
% The definition of trial data.
%
% [USAGE]
%    [obj] = vb_trial_new(from, to, onset, label, trig_ix);
% [IN]
%      trial   |--------|--------|
%             from    onset     to
%
%     from : The sample number of start point.
%            (sample number of continuous data.)
%       to : The sample number of end point.
%    onset : task starts from this sample number.
%
% [OUT]
%      obj : trial object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 3
    error('This function needs 5 fields. Please check your code.');
end

%
% --- Main Procedure
%
obj = struct;
obj.from    = from;
obj.to      = to;
obj.onset   = onset;

%
% --- After check
%
if nargout < 1
    error('function caller should receive trial object.');
end
