function [obj] = vb_integer_trigger_new(ch_name, slope, bitpattern, bitmask, offset)
% Create integer trigger.
%
% [USAGE]
%    vb_integer_trigger_new(ch_name, slope trig_level);
% [IN]
%       ch_name : extract trigger from this channel [string]
%         slope : trigger slope. ('const_start' or 'const_end') [string]
%    bitpattern : bitpattern ('00001010') [string]
%       bitmask : bit mask('00001111')    [string]
%        offset : data offset
% [OUT]
%           obj : integer_trigger object
% [see also]
%    vb_get_trigger_event
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 5
    error('This function needs 5 argments. Please check your code.');
end
if ~strcmp(slope, 'const_start') && ~strcmp(slope, 'const_end')
    error('trigger slope must be const_start or const_end');
end
if ~ischar(bitpattern)
    error('bitpattern is invalid.');
end
try
    % !!! bit pattern should be decimal number !!!(little bit strange)
    bitpattern = bin2dec(bitpattern);
catch
    error('Bit pattern: Binary string may consist only of characters ''0'' and ''1''.');
end

if ~ischar(bitmask)
    error('bitmask is invalid.');
end
try
    tmp = bin2dec(bitmask);
catch
    error('Bitmask: Binary string may consist only of characters ''0'' and ''1''.');
end

%
% --- Main Procedure
%
obj = vb_trigger_new(ch_name, 'integer', bitpattern);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obj.FIELDNAMES SHOULD BE SAME WITH vb_get_trial_time_index
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
obj.slope = slope;
obj.status_mask  = bitmask;
obj.status_offset = offset;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
