function [obj] = vb_bit_trigger_new(ch_name, slope, bit_num, bitmask, offset)
% Create bit trigger.
%
% [USAGE]
%    vb_bit_trigger_new(ch_name, slope trig_level);
% [IN]
%       ch_name : extract trigger from this channel [string]
%         slope : trigger slope. ('low_to_high' or 'high_to_low') [string]
%       bit_num : bit number [0-n]        [uint]
%       bitmask : bit mask('00001111')    [string]
%        offset : data offset
% [OUT]
%           obj : bit_trigger object
% [see also]
%    vb_get_trigger_event
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 5
    error('This function needs 5 argments. Please check your code.');
end
if ~strcmp(slope, 'low_to_high') && ~strcmp(slope, 'high_to_low')
    error('trigger slope must be ''low_to_high'' or ''high_to_low''');
end
if ~isinteger(bit_num)
    error('Invalid bit number was specified. Input integer value.');
end
try
    % !!! bit num should be double and decimal number.
    bit_num = double(2^bit_num);
catch
    error('Invalid bit number was specified. Input integer value.');
end

if ~ischar(bitmask)
    error('Bitmask: Binary string may consist only of characters 0 and 1.');
    try
        tmp = bin2dec(bitmask);
    catch
        error('Bitmask: Binary string may consist only of characters 0 and 1.');
    end
end

%
% --- Main Procedure
%
obj = vb_trigger_new(ch_name, 'bit', bit_num);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obj.FIELDNAMES SHOULD BE SAME WITH vb_get_trial_time_index
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
obj.slope = slope;
obj.status_mask  = bitmask;
obj.status_offset = offset;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
