function data = vb_trial_extractor_set_continuous_file(data, file)
% set continuous MEG/EEG-MAT file.
% [USAGE]
%    data = vb_trail_extractor_set_continuous_file(data, file)
% [IN]
%    data : vb_trial_extractor object.
%    file : continuous MEG/EEG-MAT filename.
% [OUT]
%    data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is required parameter.');
end

%
% --- Main Procedure
%
H = data.H;
try
    if ~exist('file', 'var') || exist(file, 'file') ~= 2
        error('Invalid MEG/EEG-MAT file was specified.');
    end
    if strcmp(getappdata(H.continuous_file_edit, 'file'), file)
        return;
    end
    % create continous data
    continuous_file = vb_continuous_file_new(file);
    data = vb_trial_extractor_init(data.figure);
    data.continuous_file = continuous_file;

    % clear trial data
    data.trial_list = [];
    data = vb_trial_extractor_update_screen(data);

    set(H.continuous_file_edit, 'String', file);

    % display channel settings in view function
    MEGinfo = vb_continuous_file_get_meg_info(data.continuous_file);
    measurement = vb_info_get_measurement(MEGinfo);

    data.org_data_ch_list = ...
        vb_continuous_file_get_ch_list(data.continuous_file, measurement);

    
    Ndata_ch = size(data.org_data_ch_list, 1);
    if Ndata_ch > 100
        step = ceil(Ndata_ch / 50);
        % reduce channel number for plot about 50
        data.view_data_ch_list = data.org_data_ch_list(1:step:Ndata_ch);
    else
        data.view_data_ch_list = data.org_data_ch_list;
    end

    % create channel pattern default settings(all 0)
    [ex_ch_list] = vb_continuous_file_get_ch_list(data.continuous_file, 'EXTRA');
    Next_ch = size(ex_ch_list, 1);
    data.multi_channel_pattern = cell(Next_ch, 2);
    for k=1:Next_ch
        data.multi_channel_pattern{k, 1} = ex_ch_list{k};
        data.multi_channel_pattern{k, 2} = 0; % default
    end

    % default setting for output 
    freq = vb_continuous_file_get_sample_freq(continuous_file);
    data.output_sample_freq = freq;
    
    % Save filename
    setappdata(H.continuous_file_edit, 'file', file);

catch
    set(H.continuous_file_edit, 'String', getappdata(H.continuous_file_edit, 'file'));
    [msg, msg_f] = vb_get_error_msg(lasterror);
    errordlg(msg_f, 'Continuous MEG/EEG File.');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
