function [data] = vb_trial_extractor_remove_trial(data)
% remove trial from tag.
% [USAGE]
%    [data] = vb_trial_extractor_remove_trial(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

label_all = get(H.tag_listbox, 'String');
label_ix  = get(H.tag_listbox, 'Value');
label     = label_all{label_ix};


selected_ix  = get(H.trial_set_listbox, 'Value');
remove_ix = [];
for k=1:length(selected_ix)
    remove_ix = [remove_ix; data.showing_trial_ix(selected_ix(k))];
end
if ~isempty(remove_ix)
    [tag_obj, nth] = vb_tag_util_find_tag(data.label_list, label);
    if ~isempty(tag_obj)
        data.label_list{nth} = vb_tag_remove_trial_index(tag_obj, remove_ix);
    end
    % Update viewer if a viewer is opened.
    data = vb_trial_extractor_notify_viewer(data, label);
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive updated vb_trial_extractor object.');
end
