function data = vb_trial_extractor_load_parm(data, file)
% Load parameter
% [USAGE]
%    data = vb_trial_extractor_convert_spec(data, parm);
% [IN]
%    data : vb_trial_extractor object.
%    file : trial extraction parameter file(.trx.mat)
%
% [OUT]
%    data : after loading vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('file', 'var')
    error('file is a required parameter.');
end

%
% --- Main Procedure
%
if exist(file, 'file') ~= 2
    error('Invalid file was specified.');
end

load(file, 'trx_parm');
parm = trx_parm;

% Continuous file
if isfield(parm, 'con_file') && exist(parm.con_file, 'file') == 2
    data = vb_trial_extractor_set_continuous_file(data, parm.con_file);
else
    data.continuous_file = [];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Trial Extraction section

% Trigger spec
if isfield(parm, 'trigger_list')
    data.trigger_list = parm.trigger_list;
end

% Trial length
if isfield(parm, 'trial_setting')
    data.trial_setting = parm.trial_setting;
end

% Label list
if isfield(parm, 'label_list')
    data.label_list = parm.label_list;
end

% Trial list
if isfield(parm, 'trial_list')
    data.trial_list = parm.trial_list;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output section
if isfield(parm, 'output_file')
    data.output_file = parm.output_file;
end


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end

