function [data] = vb_trial_extractor_extract_trial(data)
% This function extracts trials based on parameters.
% [USAGE]
%    [data] = vb_trial_extractor_extract_trial(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% -- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%

% gui handles
try
    H = data.H;
    if ~ishandle(data.H.figure)
        H = -1;
    end
catch
    H = -1;
end

h = -1;
if isfield(data, 'batch_mode') && data.batch_mode
    vb_disp('Now extracting trials. Please wait');
else
    h = msgbox('Now extracting trials...', 'Please wait');
    btn = findall(h, 'Style', 'pushbutton');
    set(btn, 'Visible', 'off');
end

pause(0.1);

% receive trial list
trial_list = vb_continuous_file_extract_trial(data.continuous_file, ...
                             data.trigger_list, data.trial_setting);

Ntrigger = length(data.trigger_list);

data.trial_list = [];
data.label_list   = cell(0);
data.output_file = cell(0);
if isstruct(H)
    set(H.tag_listbox, 'String', '', 'Value', 1);
    set(H.trial_set_listbox, 'String', '', 'Value', 1);
    set(H.output_listbox, 'String', '', 'Value', 1);
end

for k=1:Ntrigger
    % create TAG
    data.label_list{k} = vb_tag_new(['TRIGGER' num2str(k)]);
    % extracted trial for one trigger
    trial_set = trial_list{k};

    % Add trials to 'TRIGGERn' TAG
    for j=1:length(trial_set)
        % Register trial data to trial list
        data.trial_list = [data.trial_list; trial_set(j)];
        % Add absolute trial data index to tag object.
        data.label_list{k} = vb_tag_add_trial_index(data.label_list{k}, ...
                                                length(data.trial_list));
    end
end

if ishandle(h), delete(h); end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end

