function vb_trial_extractor_callback(fig, hObj)
% Callback function for vb_trial_extractor.
% This function is called when user operates.
% (push button, select line on listbox.)
%
% [USAGE]
%    vb_trial_extractor_callback(fig);
% [IN]
%     fig : figure handle of GUI.
%    hObj : handle of the component.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || ~ishandle(fig) || isempty(fig)
    error('Invalid figure handle were specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
%get(hObj, 'Tag') % debug
data = guidata(fig);
H    = data.H;

switch(hObj)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Load/Save parameter
    case H.load_settings
        [d, f] = vb_file_select({'.trx.mat'}, ...
                 'Load batch parameter');
        if isempty(d), return; end
        file = [d, filesep, f{1}];
        data = vb_trial_extractor_load_parm(data, file);
        data = vb_trial_extractor_update_screen(data);
   case H.save_settings
        [d, f] = vb_file_select({'.trx.mat'}, ...
                  'Save batch parameter', true);
        if isempty(d), return; end
        file = [d, filesep, f{1}];
        vb_trial_extractor_save_parm(data, file);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Base file(Continous MEG/EEG-MAT)
    case H.continuous_file_edit
        file = get(hObj, 'String');
        data = vb_trial_extractor_set_continuous_file(data, file);
    case H.continuous_file_push
        [d, f] = vb_file_select({'.meg.mat', '.eeg.mat'}, ...
            'Select MEG/EEG file which contains continuous data');
        if isempty(d), return; end
        file = [d, filesep, f{1}];
        data = vb_trial_extractor_set_continuous_file(data, file);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Trial settings
    case { H.pretrigger_length_edit, H.posttrigger_length_edit}
        Value = get(hObj, 'String');
        Value = str2double(Value);
        if hObj == H.pretrigger_length_edit
            field = 'pretrigger_ms';
        elseif hObj == H.posttrigger_length_edit
            field = 'posttrigger_ms';
        end
        if isnan(Value) || ~isnumeric(Value) || Value <= 0
            set(hObj, 'String', '');
            data.trial_setting.(field) = 0;
            errordlg('Invalid value was specified. Please input positive value.', 'Trial settings');
        else
            % Get Pre|Post trigger settings
            data.trial_setting.(field) = Value;
        end
        data = vb_trial_extractor_update_screen(data);
    case H.minimum_distance_edit
        val = get(hObj, 'String');
        if isempty(val)
            % do nothing
            data.trial_setting.minimum_distance_ms = [];
        else
            val = str2double(val);
            if isnan(val) || ~isnumeric(val) || val < 0
                errordlg('Invalid value was specified. Please input positive value. If empty is specified, stop checking.', 'Trial settings');
            else
                data.trial_setting.minimum_distance_ms = val;
            end
        end
        data = vb_trial_extractor_update_screen(data);
        
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Trigger settings
    case H.trigger_channel_listbox
        data = vb_trial_extractor_update_screen(data);
    case H.trigger_view_push
        data = vb_trial_extractor_preview_trial(data, 1);
    case H.ch_property_push
        data = vb_trial_extractor_show_channel_property(data);
    case H.trigger_type_popup
         data = vb_trial_extractor_update_screen(data);
    case H.trigger_slope_popup
    case H.trigger_level_edit
    case H.flag_pattern_push
        [data] = vb_trial_extractor_input_multi_pattern(data);
    case H.trigger_help_push
        fid = fopen(which('vb_trial_extractor_trig_help.txt'));
        if fid ~= -1
            help_txt = char(fread(fid, inf, 'char'))';
            vb_text_area('trigger', help_txt);
            fclose(fid);
        end
    case H.trigger_add_push
        % create trigger object
        trig_obj = vb_trial_extractor_create_trigger(data);
        % register created trigger
        Ntrigger = length(data.trigger_list);
        data.trigger_list{Ntrigger+1} = trig_obj;
        % update screen
        set(H.trigger_list_listbox, 'Value', 1);
        set(H.tag_listbox, 'Value', 1);
        data = vb_trial_extractor_update_screen(data);
    case {H.optional_parm_push, H.advanced_parm_push}
        trig_type_list  = get(H.trigger_type_popup, 'String');
        trig_type = trig_type_list{get(H.trigger_type_popup, 'Value')};
        switch(trig_type)
            case {'bit', 'integer'}
                field = 'data.trigger_adjust_parameter';
                caption = 'Adjustment parameter for digital trigger';
            case 'emg'
                if hObj == H.optional_parm_push
                    field = 'data.emg_parm.optional_parm';
                    caption = 'EMG(Optional parameter)';
                else
                    field = 'data.emg_parm.advanced_parm';
                    caption = 'EMG(Advanced parameter)';
                end
            case 'voice'
                if hObj == H.optional_parm_push
                    field = 'data.voice_parm.optional_parm';
                    caption = 'Voice(Optional parameter)';
                else
                    field = 'data.voice_parm.advanced_parm';
                    caption = 'Voice(Advanced parameter)';
                end
            otherwise
                error('Unknown trigger type is selected.');
        end

        edit = true;
        parm = eval(field);
        while(edit)
        [parm, cancelled] = ...
            vb_edit_struct(parm, caption);
            if ~cancelled
                try
%                     if isempty(parm.Data_offset) || isnan(parm.Data_offset)
%                         error('Invalid Data offset was specified.');
%                     end
%                     bin2dec(parm.Bitmask);
                    edit = false;
                    eval([field ' = parm;']);
                catch
                    [msg, msg_f] = vb_get_error_msg(lasterror);
                    h = errordlg(msg_f, caption);
                    waitfor(h);
                    edit = true;
                end
            else
                return;
            end        
        end
    case H.trigger_list_view_push
        data = vb_trial_extractor_preview_trial(data, 2);
   case H.trigger_list_remove_push
        ix = get(H.trigger_list_listbox, 'Value');
        data.trigger_list(ix) = [];
        Ntrig = length(data.trigger_list);
        if max(ix) > Ntrig && Ntrig >= 1
            set(H.trigger_list_listbox, 'Value', Ntrig);
        end
        data = vb_trial_extractor_update_screen(data);
    case H.trigger_edit_push
         disp('Not implemented yet.');
    case H.trigger_detect_push
        data = vb_trial_extractor_extract_trial(data);
        data = vb_trial_extractor_update_screen(data);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Extracted trials
    case H.tag_listbox
        set(H.trial_set_listbox, 'Value', 1);
        data = vb_trial_extractor_update_screen(data);
    case H.trial_set_listbox
        data = vb_trial_extractor_update_screen(data);
    case H.tag_remove_push
        val = get(H.tag_listbox, 'Value');
        if ~isempty(val)
            data.label_list(val) = [];
            Ntag = length(data.label_list);
           if max(val) > Ntag && Ntag >= 1
                set(H.tag_listbox, 'Value', Ntag);
            end
        end
        data = vb_trial_extractor_update_screen(data);
    case H.trial_add_push
        data = vb_trial_extractor_add_trial(data);
        data = vb_trial_extractor_update_screen(data);
    case H.trial_remove_push
        data = vb_trial_extractor_remove_trial(data);
        data = vb_trial_extractor_update_screen(data);
    case H.trial_edit_push
        data = vb_trial_extractor_edit_trial(data);
        data = vb_trial_extractor_update_screen(data);
    case H.tag_file_push
        row  = get(H.tag_listbox, 'Value');
        if isempty(row), return; end
        [d, f] = vb_file_select({'.txt'}, 'Select Label file(*.txt)');
        if isempty(d), return; end
        tag_file = [d, filesep, f{1}];

        tags = get(H.tag_listbox, 'String');
        selected_tags = tags(row);

        tag_spec.label_file = tag_file;
        tag_spec.base_label = selected_tags;
        tag_spec.overwrite  = false;
        data = vb_trial_extractor_tag_by_file(data, tag_spec);
        data = vb_trial_extractor_update_screen(data);
    case H.tag_selected_trial_push
        list_index = get(H.trial_set_listbox, 'Value')';
        if isempty(list_index), return; end
        new_tag = inputdlg('Input Label name : ', 'Create Label for selected trial.');
        if ~isempty(new_tag) && ~isempty(new_tag{1})
            data = vb_trial_extractor_tag_by_hand(data, list_index, new_tag{1});
            data = vb_trial_extractor_update_screen(data);
        end
    case H.trial_select_all_push
        Ntrial = length(get(H.trial_set_listbox, 'String'));
        set(H.trial_set_listbox, 'Value', [1:Ntrial]);
        data = vb_trial_extractor_update_screen(data);
    case H.channel_selection_push
        data = vb_trial_extractor_specify_display_channel(data);
    case H.preview_push
        data = vb_trial_extractor_preview_trial(data);
    case H.add_to_output_list_button
        tag_id_list = get(H.tag_listbox, 'Value')';
        data = vb_trial_extractor_add_tag_to_output_list(data, tag_id_list);
        data = vb_trial_extractor_update_screen(data);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Output file
    case H.output_file_remove_push
         idx = get(H.output_listbox, 'Value')';
         data = vb_trial_extractor_remove_output_file(data, idx);
         Nfile = size(data.output_file, 2);
         if max(idx) > Nfile && Nfile >= 1
             set(H.output_listbox, 'Value', Nfile);
         end
         data = vb_trial_extractor_update_screen(data);
    case H.output_settings_push
        cur.output_sampling_frequency = data.output_sample_freq;
        loop = true;
        while(loop)
            [cur, canceled] = vb_edit_struct(cur, 'Output settings');
            if canceled
                loop = false;
            else
                val = cur.output_sampling_frequency;
                if ~isnan(val) && isnumeric(val) && val > 0
                    data.output_sample_freq = cur.output_sampling_frequency;
                    loop = false;
                else
                    h = errordlg('Invalid value was specified. Please input positive value.',...
                             'Output sampling frequency');
                    uiwait(h);
                end
            end
        end
    case H.output_file_push
        data = vb_trial_extractor_output_file(data);
end

guidata(fig, data);
