function [data] = vb_trial_extractor_add_tag_to_output_list(data, tag_id_list)
% Add selected TAG to output list
% [USAGE]
%    [data] = vb_trial_extractor_add_tag_to_output_list(data, tag_id_list);
% [IN]
%           data : vb_trial_extractor object.
%    tag_id_list : tag id list [Nx1]
% [OUT]
%    data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('tag_id_list', 'var')
    error('tag_id_list is a required parameter.');
end
if size(tag_id_list, 2) ~= 1
    error('The shape of tag_id_list should be [Nx1]');
end
if length(data.label_list) == 0, return; end
%
% --- Main Procedure
%
Nadd      = size(tag_id_list, 1);
Nregister = length(data.output_file);

org_file  = vb_continuous_file_get_filename(data.continuous_file);
extension = org_file(end-8+1:end);

% remove extension
base_file = strrep(org_file, extension, '');

% data.output_file{k}.label_name = 'TRIGGER1'
%                     output_file = 'TRIG1.meg.mat'
for k=1:Nadd
    tag_name = vb_tag_get_tag_name(data.label_list{tag_id_list(k)});
    output_file = [base_file, '_', tag_name, extension];
    data.output_file{Nregister+k}.label_name  = tag_name;
    data.output_file{Nregister+k}.output_file = output_file;
end

if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
