function data = vb_signal_processor_update_screen(data)
% Update GUI.
% [USAGE]
%    data = vb_signal_processor_update_screen(data);
% [IN]
%    data : Application data.
% [OUT]
%    data : Application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required paraemter.');
end

%
% --- Main Procedure
%
H = data.H;
d = vb_define_signal_processor;

%%%%%%%%%%%%%%%%%%%%%%%%
% Input MEG/EEG file list
set(H.input_file_listbox, 'String', data.input_files);

% Adjust focus line
selected = get(H.input_file_listbox, 'Value');
if isempty(selected) || selected <= 0
    selected = 1;
    set(H.input_file_listbox, 'Value', 1);
end
Nfiles     = length(data.input_files);
if selected > Nfiles && selected ~= 1
    selected = Nfiles;
    set(H.input_file_listbox, 'Value', Nfiles);
end

% Change View button status
if isempty(data.input_files) || ...
   exist(data.input_files{selected}, 'file') ~= 2
    set(H.input_file_remove_push, 'Enable', 'off');
    set(H.input_file_view_push, 'Enable', 'off');
else
    set(H.input_file_remove_push, 'Enable','on');
    set(H.input_file_view_push, 'Enable', 'on');
end

%%%%%%%%%%%%%
% File type
%
% reset radiobutton
H = data.H;
group = [H.file_type_meg_radiobutton; ...
         H.file_type_eeg_radiobutton];
set(group, 'Value', 0);

% set radiobutton
switch(data.file_type)
    case 'MEG'
        set(H.file_type_meg_radiobutton, 'Value', 1);
    case 'EEG'
        set(H.file_type_eeg_radiobutton, 'Value', 1);
    otherwise
        error('Invalid File type was specified.');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Process list
Nprocess = length(data.process_list);
parm_names = cell(0);
focus_line = get(H.process_list_listbox, 'Value');

for k=1:Nprocess
    parm_names{k} = vb_table_query_value(d.type_str_table, ...
                                         data.process_list{k}.type);
end
set(H.process_list_listbox, 'String', parm_names);
if focus_line > Nprocess && focus_line ~= 1
    focus_line = Nprocess;
    set(H.process_list_listbox, 'Value', Nprocess);
end
btn_proclist = [H.process_list_remove_push, ...
                H.process_list_edit_push, ...
                H.process_list_view_push, ...
                H.process_list_upper_push, ...
                H.process_list_lower_push];
if Nprocess == 0
    set(btn_proclist, 'Enable', 'off');
else
    set(btn_proclist, 'Enable', 'on');
end

% Activate View button when the selected filter 
% can be seen by vb_plot_filter_response.
if ~isempty(data.process_list)
    selected_filt_type = data.process_list{focus_line}.type;
    response_filters   = {d.TYPE_PROCESSING_HIGHPASS;
                          d.TYPE_PROCESSING_LOWPASS;
                          d.TYPE_PROCESSING_BANDPASS;
                          d.TYPE_PROCESSING_STOPBAND};
    set(H.process_list_view_push, 'Enable', 'off');
    for k=1:length(response_filters)
        if isequal(selected_filt_type, response_filters{k})
            set(H.process_list_view_push, 'Enable', 'on');
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output MEG/EEG file list
set(H.output_file_listbox, 'String', data.output_files);
selected = get(H.output_file_listbox, 'Value');
if isempty(selected) || selected <= 0
    selected = 1;
    set(H.output_file_listbox, 'Value', 1);
end
if selected <= 0|| (selected > Nfiles && selected ~= 1)
    selected = Nfiles;
    set(H.output_file_listbox, 'Value', Nfiles);
end
if isempty(data.output_files) || ...
   exist(data.output_files{selected}, 'file') ~= 2

    set(H.output_file_view_push, 'Enable', 'off');
else
    set(H.output_file_view_push, 'Enable', 'on');
end

if ~isempty(data.input_files) && ~isempty(data.process_list)
    set(H.exec_push, 'Enable', 'on');
else
    set(H.exec_push, 'Enable', 'off');
end
%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end

