function data = vb_signal_processor_save_settings(data)
% Save batch file(.proc.mat).
% [USAGE]
%    data = vb_signal_processor_save_settings(data);
% [IN]
%    data : Application data.
% [OUT]
%    data : Application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
proc_parm = struct;
proc_parm.input_files  = data.input_files;
proc_parm.output_files = data.output_files;
proc_parm.process_list = data.process_list;

[d, flist] = vb_file_select({'.proc.mat'}, 'Save setting file(.proc.mat)', true);
if ~isempty(d)
    save_file = fullfile(d, flist{1});
    vb_save(save_file, 'proc_parm');
end
