function data = vb_signal_processor_remove_input_file(data, nth)
% Remove data file from Input MEG/EEG file list.
% [USAGE]
%    data = vb_signal_processor_remove_input_file(data, nth);
% [IN]
%   data : Application data.
%    nth : Nth item in MEG/EEG file listt.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('nth', 'var')
    error('nth is a required parameter.');
end

%
% --- Main Procedure
%
Nfile = length(data.input_files);
if Nfile < nth
    error('Inconsistent file status (file list and selected item).');
end

% Remove
data.input_files(nth) = [];
data.output_files(nth) = [];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
