function [data] = vb_signal_processor_input_megfile(data)
% Show input dialog
% [USAGE]
%    data = vb_signal_processor_input_megfile(data);
% [IN]
%    data : application data.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

def = vb_define_extension;

switch(data.file_type)
    case 'MEG'
        extension = def.MEG2_EXTENSION;
    case 'EEG'
        extension = def.EEG_EXTENSION;
end

% Select file
[d, f] = vb_file_select({extension}, ['Select ' data.file_type ' file']);

if ~isempty(d)
    files = get(H.input_file_listbox, 'String');
    file  = fullfile(d, f{1});
    if isempty(files)
        files{1} = file;
    else
        files{length(files)+1} = file;
    end
    data.input_files  = files;
end
data = vb_signal_processor_create_output_filename(data);

data = vb_signal_processor_update_screen(data);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive application data object.');
end
