function d = vb_define_signal_processor
% Constant value definition of GUI.
% [USAGE]
%    d = vb_define_signal_filter;
% [IN]
%    none
% [OUT]
%    d : constant value definition.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definition of Processing type and string on GUI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% inner data type(basically do not change these values)
d.TYPE_PROCESSING_BIAS_CORRECTION = 'biascorr';
d.TYPE_PROCESSING_HIGHPASS        = 'highpass';
d.TYPE_PROCESSING_LOWPASS         = 'lowpass';
d.TYPE_PROCESSING_BANDPASS        = 'bandpass';
d.TYPE_PROCESSING_STOPBAND        = 'stopband';
d.TYPE_PROCESSING_DOWNSAMPLE      = 'downsampling';
d.TYPE_PROCESSING_COMMON_REFERENCE= 'common_reference';

% Expression on GUI(these values are able to change)
d.STR_BIAS_CORRECTION = 'Bias correction';
d.STR_HIGHPASS        = 'Highpass';
d.STR_LOWPASS         = 'Lowpass';
d.STR_BANDPASS        = 'Bandpass';
d.STR_STOPBAND        = 'Stop-band';
d.STR_DOWNSAMPLE      = 'Downsampling';
d.STR_COMMON_REFERENCE= 'Common reference';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create table (type, string)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tbl = [];
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_BIAS_CORRECTION, d.STR_BIAS_CORRECTION));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_HIGHPASS, d.STR_HIGHPASS));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_LOWPASS, d.STR_LOWPASS));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_BANDPASS, d.STR_BANDPASS));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_STOPBAND, d.STR_STOPBAND));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_DOWNSAMPLE, d.STR_DOWNSAMPLE));
tbl = vb_table_insert(tbl, vb_key_value_pair(...
    d.TYPE_PROCESSING_COMMON_REFERENCE, d.STR_COMMON_REFERENCE));

d.type_str_table = tbl;

%%%%%%%%%%%%%%%%%%%%%
% Default parameter
%%%%%%%%%%%%%%%%%%%%%

% Bias correction
d.bias_correction_parm = struct;
d.bias_correction_parm.type    = d.TYPE_PROCESSING_BIAS_CORRECTION;
d.bias_correction_parm.mode    = 1;

% Highpass
d.highpass_parm      = struct;
d.highpass_parm.type = d.TYPE_PROCESSING_HIGHPASS;
d.highpass_parm.cutoff_freq      = 1;
d.highpass_parm.impulse_response = 2; % =1:FIR, =2:IIR
d.highpass_parm.order            = 3;
d.highpass_parm.filtfilt         = 1;

% Lowpass
d.lowpass_parm       = struct;
d.lowpass_parm.type  = d.TYPE_PROCESSING_LOWPASS;
d.lowpass_parm.cutoff_freq       = 100;
d.lowpass_parm.impulse_response  = 2; % = 1:FIR, =2:IIR
d.lowpass_parm.order             = 5;
d.lowpass_parm.filtfilt          = 1;

% Bandpass
d.bandpass_parm      = struct;
d.bandpass_parm.type = d.TYPE_PROCESSING_BANDPASS;
d.bandpass_parm.cutoff_freq_low  = 1;
d.bandpass_parm.cutoff_freq_high = 60;
d.bandpass_parm.impulse_response = 2; % = 1:FIR, =2:IIR
d.bandpass_parm.order            = 5;
d.bandpass_parm.filtfilt         = 1;

% Stop-band
d.stopband_parm      = struct;
d.stopband_parm.type = d.TYPE_PROCESSING_STOPBAND;
d.stopband_parm.cutoff_freq_low  = 45;
d.stopband_parm.cutoff_freq_high = 55;
d.stopband_parm.impulse_response = 2; % = 1:FIR, =2:IIR
d.stopband_parm.order            = 5;
d.stopband_parm.filtfilt         = 1;

% Downsampling
d.down_sample_parm      = struct;
d.down_sample_parm.type = d.TYPE_PROCESSING_DOWNSAMPLE;
d.down_sample_parm.dsamp_freq = 250;

% Common Reference
d.common_ref_parm      = struct;
d.common_ref_parm.type = d.TYPE_PROCESSING_COMMON_REFERENCE;
d.common_ref_parm.mode = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Definition of processing tempalte for EEG/MEG
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
d.process_template_EEG = { ...
    d.TYPE_PROCESSING_BIAS_CORRECTION;
    d.TYPE_PROCESSING_HIGHPASS;
    d.TYPE_PROCESSING_LOWPASS;
    d.TYPE_PROCESSING_BANDPASS;
    d.TYPE_PROCESSING_STOPBAND;
    d.TYPE_PROCESSING_DOWNSAMPLE;
    d.TYPE_PROCESSING_COMMON_REFERENCE};

d.process_template_MEG = { ...
    d.TYPE_PROCESSING_BIAS_CORRECTION;
    d.TYPE_PROCESSING_HIGHPASS;
    d.TYPE_PROCESSING_LOWPASS;
    d.TYPE_PROCESSING_BANDPASS;
    d.TYPE_PROCESSING_STOPBAND;
    d.TYPE_PROCESSING_DOWNSAMPLE};

