function pa_leadfield_callback(fig, hObj)
% callback function for leadfield gui.
% [USAGE]
%    pa_leadfield_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of leadfield gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_brain_create)
data = guidata(fig);
H = data.H;

switch( hObj )
    case H.prjroot_push
        dir = dir_dialog(get(H.prjroot_edit, 'String'));
        if dir ~= 0
            set(H.prjroot_edit, 'String', dir);
        end
    case H.megmat_file_edit
        pa_leadfield_util(fig, 'update_output_fname');
        pa_leadfield_util(fig, 'update_exec_push_status');
    case H.megmat_file_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname cancelled] = pa_prjfile_select(proj_root,...
                                        {define.MEG2_EXTENSION, ...
                                         define.EEG_EXTENSION}, ...
                                         'Select MEG/EEG data');
        if ~cancelled
            megmat_file = [dir filesep fname{1}];
            set(H.megmat_file_edit, 'String', megmat_file);
            pa_leadfield_util(fig, 'update_output_fname');
            % load spherical center from MEG-MAT file.
            [pick, Qpick, CoilWeight, Vcenter] = ...
                vb_load_sensor([proj_root, filesep, megmat_file]);
            set(H.center_head_edit, 'String', num2str(Vcenter, 3));
            % sphere radius default
            data.Vradius = 0.08;
            guidata(fig, data);
        end
    case H.brain_file_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root,...
                                                 {define.BRAIN_EXTENSION},...
                                                 'Select cortical model file');
        if ~canceled
            set(H.brain_file_edit, 'String', [dir filesep fname{1}]);
            pa_leadfield_util(fig, 'update_exec_push_status');
        end
    case H.area_file_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root, ...
                                                 {define.AREA_EXTENSION}, ...
                                                 'Select cortical area file');
        if ~canceled
            set(H.area_file_edit, 'String', [dir filesep fname{1}]);
        end
    case H.head_file_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root,...
                                                 {'.head.mat'},...
                                                 'Select head model file');%?.head.mat'
        if ~canceled
            set(H.head_file_edit, 'String', [dir filesep fname{1}]);
            pa_leadfield_util(fig, 'update_exec_push_status');
        end
    case H.save_dir_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir canceled] = pa_prjdir_select(proj_root);
        if ~canceled
            set(H.save_dir_edit, 'String', dir);
            pa_leadfield_util(fig, 'update_output_fname');
            pa_leadfield_util(fig, 'update_exec_push_status');
        end
    case H.exec_push
        pa_leadfield_util(fig, 'exec_leadfield');
    case H.save_dir_edit
        pa_leadfield_util(fig, 'update_output_fname');
        pa_leadfield_util(fig, 'update_exec_push_status');
    case H.BemMode_popup
        bem_mode = pa_leadfield_util(fig, 'get_bem_mode');
        pa_leadfield_util(fig, 'set_bem_mode', bem_mode);
        pa_leadfield_util(fig, 'update_exec_push_status');
    case H.center_head_push
        pa_leadfield_make_center_sphere(fig);
        pa_leadfield_util(fig, 'update_exec_push_status');
    case {H.center_head_edit, H.conductivity_edit, ...
          H.sphere_radius_edit, H.head_file_edit}
        pa_leadfield_util(fig, 'update_exec_push_status');
    case H.leadfield_parm_push
        if ishandle(data.adv_fig)
            figure(data.adv_fig);
        else
            data.adv_fig = pa_leadfield_parm_gui_create(fig,data.basis_parm);
            % save data
            guidata(fig, data);
        end
    case H.check_push
        pa_leadfield_util(fig, 'check_model');
    %%%%%%%%%%
    % Menu
    case {H.figure, H.menu_close}
        pa_leadfield_close(fig);
        return;
    case H.menu_leadfield_calculation
        url = vb_users_manual_url('Leadfield calculation');
        vb_browser_show(url);
        
end
