function [fig] = pa_head_create(proj_root)
% This function creates head parameter gui.
% [USAGE]
%    fig = pa_head_create([proj_root]);
% [IN]
%    proj_root : project root directory.
% [OUT]
%    fig : figure handle of head gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_head.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.adv_fig = -1; % figure handle of head advanced parameter gui.


% parameter for GUI
data.head_parm = vb_set_head_parm;

% save data to figure
guidata(fig, data);

set(data.H.prjroot_edit, 'String', proj_root);
pa_head_set_parm(fig, data.head_parm);
