function pa_fmri_callback(fig, hObj)
% callback function for fmri gui.
% [USAGE]
%    pa_fmri_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of fmri gui.
%    hObj : component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_fmri_create)
data = guidata(fig);
H = data.H;

switch( hObj )
    case H.prjroot_push
        dir = dir_dialog(get(H.prjroot_edit, 'String'));
        if dir ~= 0
            set(H.prjroot_edit, 'String', dir);
        end
    case H.spm_push
        [dir fname] = vb_file_select({'.mat'}, 'Select SPM result file');
        if ~isempty(dir)
            spm_result_file = fullfile(dir, fname{1});
            pa_fmri_util(fig, 'set_spm_result_file', spm_result_file);
            pa_fmri_util(fig, 'update_exec_push_status');
        end
    case H.spm_normalization_file_push
        [dir fname] = vb_file_select({'_sn.mat'}, 'Select SPM normalization file');
        if ~isempty(dir)
            spm_normalization_file = fullfile(dir, fname{1});
            set(H.spm_normalization_file_edit, 'String', spm_normalization_file);
            pa_fmri_util(fig, 'update_exec_push_status');
        end
    case H.spm_mni2subj_radiobutton
        pa_fmri_util(fig, 'set_spm_type', 'mni2subj');
    case H.spm_mni2mni_radiobutton
        pa_fmri_util(fig, 'set_spm_type', 'mni2mni');
    case H.spm_subj2subj_radiobutton
        pa_fmri_util(fig, 'set_spm_type', 'subj2subj');
    case H.postfix_push
        res = inputdlg('Input Area/Activity ID Postfix', 'Input', 1, {data.keys_postfix});
        if ~(iscell(res) && isempty(res))
            data.keys_postfix = res{1};
            guidata(fig, data);
            spm_result_file = get(H.spm_edit, 'String');
            if exist(spm_result_file, 'file') == 2
                pa_fmri_util(fig, 'set_spm_result_file', spm_result_file);
                pa_fmri_util(fig, 'update_exec_push_status');
            end
        end
    case H.brain_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root, {define.BRAIN_EXTENSION}, 'Select cortical model file');
        if ~canceled
            brain_file = fullfile(dir, fname{1});
            set(H.brain_file_edit, 'String', brain_file);

            area_file = strrep(brain_file, define.BRAIN_EXTENSION, define.AREA_EXTENSION);
            act_file  = strrep(brain_file, define.BRAIN_EXTENSION, define.FMRI_EXTENSION);
            
            area_file_abs = fullfile(proj_root, area_file);
            act_file_abs   = fullfile(proj_root, act_file);
            if exist(area_file_abs, 'file') == 2
                set(H.area_file_edit, 'String', area_file);
            end
            if exist(act_file_abs, 'file') == 2
                set(H.act_file_edit,  'String', act_file);
            end
            pa_fmri_util(fig, 'update_exec_push_status');
        end
    case H.area_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root, {define.AREA_EXTENSION}, 'Select cortical area file');
        if ~canceled
            set(H.area_file_edit, 'String', [dir filesep fname{1}]);
            pa_fmri_util(fig, 'update_exec_push_status');
        end
    case H.act_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root, {define.FMRI_EXTENSION}, 'Select cortical activity file');
        if ~canceled
            set(H.act_file_edit, 'String', [dir filesep fname{1}]);
            pa_fmri_util(fig, 'update_exec_push_status');
        end
    case H.exec_push
        pa_fmri_util(fig, 'exec_fmri');
    case H.brain_file_edit
        pa_fmri_util(fig, 'update_exec_push_status');
    case H.spm_edit
        pa_fmri_util(fig, 'update_exec_push_status');
    case H.fmri_parm_push
        if ishandle(data.adv_fig)
            figure(data.adv_fig);
        else
            data.adv_fig = pa_fmri_parm_gui_create(fig, data.fmri_parm);
        end
    %%%%%%%%%%%%%%%%%%%%%%%%%    
    % Menu
    case {H.figure, H.menu_close}
        pa_fmri_close(fig);
        return;
    case H.menu_about_fmri_data
        urls = vb_users_manual_url('fMRI data');
        vb_browser_show(urls{1});
    case H.menu_import_fmri_data
        urls = vb_users_manual_url('fMRI data');
        vb_browser_show(urls{2});
end

% save data
guidata(fig, data);
