function pa_fmri_parm_gui_set_parm(fig, fmri_parm)
% set fmri_parm to advanced parameter gui.
% [USAGE]
%    pa_fmri_parm_gui_get_parm(<fig>, <fmri_parm>);
% [IN]
%          fig : figure handle of fmri advanced parameter gui.
%    fmri_parm : fmri_parm
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('figure handle is invalid.');
end
if ~exist('fmri_parm')
    fmri_parm = vb_set_fmri_parm; % default
end

%
% --- Main Procedure
%
data = guidata(fig);
H = data.H;

% T-value threshold (one-sided)
val = fmri_parm.Tthres;
set_value(H.T_value_edit, num2str(val));

% Percent signalchange threshold (two-sided) (unit : %)
val = fmri_parm.PSthres;
set_value(H.PS_threshold_edit, num2str(val));

% Radius threshold for converting a voxel image to a surface image (unit:mm)
val = fmri_parm.Rthres;
set_value(H.spm_radius_edit, num2str(val));

function set_value(h, str)
set(h, 'String', str);
setappdata(h, 'pre_val', str);
