function [fmri_parm] = pa_fmri_parm_gui_get_parm(fig)
% get fmri_parm from fmri advanced parameter gui.
% [USAGE]
%    fmri_parm = pa_fmri_parm_gui_get_parm(fig);
% [IN]
%    fig : figure handle of fmri advanced parameter gui.
% [OUT]
%    fmri_parm : advanced parameter of fmri_parm.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('figure handle is invalid.');
end

%
% --- Main Procedure
%
data = guidata(fig);
H = data.H;

fmri_parm.Rthres = str2num(get(H.spm_radius_edit, 'String'));
fmri_parm.PSthres = str2num(get(H.PS_threshold_edit, 'String'));
fmri_parm.Tthres = str2num(get(H.T_value_edit, 'String'));
