function pa_brain_util(fig, command)
% This function is subcontracting function of brain GUI.
% [USAGE]
%    pa_brain_util(<fig>, <command>);
% [IN]
%        fig : figure handle of brain gui.
%    command : command
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('command', 'var') || isempty(command)
    error('invalid command is specified.');
end

%
% --- Main Procedure
%

% load data(@see pa_brain_create)
data = guidata(fig);

switch(command)
    case 'update_exec_push_status'
        update_exec_push_status(data.H);
    case 'update_output_fname'
        update_output_fname(data.H, data.output_filename);
    case 'update_model_type'
        update_model_type(data.H);
    case 'exec_brain'
        exec_brain(data);
end

% save data
guidata(fig, data);

function update_output_fname(H, output_filename)
% This function makes output filename and sets filename to GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    global vbmeg_inst;
    define = vbmeg_inst.const;

    % save_dir
    save_dir = get(H.save_dir_edit, 'String');

    if isempty(output_filename)
        % make output filename from analyze filename
        fname   = get(H.analyze_edit, 'String');
        sep     = [];
        if isempty(fname) | isempty(fname)
            return;
        end

        % get Analyze filename(without path and extension)
        [f_path, f_name, f_ext] = vb_get_file_parts(fname);

    else
        f_name = output_filename;
    end

    % 'BRAIN file'
    brain_file = [save_dir, filesep, f_name, define.BRAIN_EXTENSION];
    set(H.brain_file_edit, 'String', brain_file);
    % 'AREA file'
    area_file = [save_dir, filesep, f_name, define.AREA_EXTENSION];
    set(H.area_file_edit, 'String', area_file);
    % 'ACT file'
    act_file = [save_dir, filesep, f_name, define.FMRI_EXTENSION];
    set(H.act_file_edit, 'String', act_file);

    update_exec_push_status(H);

function update_exec_push_status(H)
% This function changes Exec button status.(clickable or not)
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    % Analyze file input check
    if isempty(get(H.analyze_edit, 'String'))
        set(H.brain_exec_push, 'Enable', 'off');
        return;
    end
    % Save directory input check
    if isempty(get(H.save_dir_edit, 'String'))
        set(H.brain_exec_push, 'Enable', 'off');
        return;
    end

    if get(H.model_brainvoyager_radiobutton, 'Value')
        % BrainVoyager file input check
        if ~isempty(get(H.left_edit, 'String')) && ...
           ~isempty(get(H.right_edit, 'String')) && ...
           ~isempty(get(H.left_inflate_edit, 'String')) &&...
           ~isempty(get(H.right_inflate_edit, 'String'))
           % ~isempty(get(H.keyword_edit, 'String'))
            set(H.brain_exec_push, 'Enable', 'on');
        else
            set(H.brain_exec_push, 'Enable', 'off');
        end
    elseif get(H.model_freesurfer_radiobutton, 'Value')
        % FreeSurfer file input check
        if exist(get(H.freesurfer_left_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_right_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_left_inflate_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_right_inflate_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_left_curv_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_right_curv_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_left_label_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_right_label_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_left_sphere_edit, 'String'), 'file') == 2 && ...
           exist(get(H.freesurfer_right_sphere_edit, 'String'), 'file') == 2
            set(H.brain_exec_push, 'Enable', 'on');
        else
            set(H.brain_exec_push, 'Enable', 'off');
        end
    else
       set(H.brain_exec_push, 'Enable', 'off');
    end

function exec_brain(data)
% This function execute vb_job_brain with set parameter.
% [IN]
%    data : data of brain gui(@see pa_brain_create)
% [OUT]
%    none

    H = data.H;

    %%%%%%%%%%%%%%%%%%%%
    % Parameter setting
    %%%%%%%%%%%%%%%%%%%%
    % project root directory
    proj_root = get(H.prjroot_edit, 'String');

    % advanced parameters are set here.
    brain_parm = data.brain_parm;
    
    % Analyze file
    brain_parm.analyze_file = get(H.analyze_edit, 'String');

    if get(H.model_brainvoyager_radiobutton, 'Value')
        %
        % --- BrainVoyager
        %
        % Left-brain file
        brain_parm.BV_left_file = get(H.left_edit, 'String');
        % Right-brain file
        brain_parm.BV_right_file = get(H.right_edit, 'String');
        % Left-inflate file
        brain_parm.BV_left_infl_file = get(H.left_inflate_edit, 'String');
        % Right-inflate file
        brain_parm.BV_right_infl_file = get(H.right_inflate_edit, 'String');

        % SPM normalization file
        brain_parm.spm_normalization_file = get(H.spm_normalization_file_edit, 'String');

    elseif get(H.model_freesurfer_radiobutton, 'Value')
        %
        % --- FreeSurfer
        %
        % Left-brain file
        brain_parm.FS_left_file = get(H.freesurfer_left_edit, 'String');
        % Right-brain file
        brain_parm.FS_right_file = get(H.freesurfer_right_edit, 'String');
        % Left-inflate file
        brain_parm.FS_left_infl_file = get(H.freesurfer_left_inflate_edit, 'String');
        % Right-inflate file
        brain_parm.FS_right_infl_file = get(H.freesurfer_right_inflate_edit, 'String');
        % Left-curv file
        brain_parm.FS_left_curv_file = get(H.freesurfer_left_curv_edit, 'String');
        % Right-curv file
        brain_parm.FS_right_curv_file = get(H.freesurfer_right_curv_edit, 'String');
        % Left-label file
        brain_parm.FS_left_label_file = get(H.freesurfer_left_label_edit, 'String');
        % Right-label file
        brain_parm.FS_right_label_file = get(H.freesurfer_right_label_edit, 'String');
        % Left-sphere file
        brain_parm.FS_left_sphere_file = get(H.freesurfer_left_sphere_edit, 'String');
        % Right-sphere file
        brain_parm.FS_right_sphere_file = get(H.freesurfer_right_sphere_edit, 'String');

        % Sphere model registration
        brain_parm.registration_mode='FS';
        brain_parm.FS_sphere_key        = 'sphere.reg';

        % remove BV field(default is set by vb_set_brain_parm.m)
        if isfield(brain_parm, 'BV_left_file')
            brain_parm = rmfield(brain_parm, 'BV_left_file');
        end
        if isfield(brain_parm, 'BV_right_file')
            brain_parm = rmfield(brain_parm, 'BV_right_file');
        end
        if isfield(brain_parm, 'BV_left_infl_file')
            brain_parm = rmfield(brain_parm, 'BV_left_infl_file');
        end
        if isfield(brain_parm, 'BV_right_infl_file')
            brain_parm = rmfield(brain_parm, 'BV_right_infl_file');
        end
    end

    % BRAIN file
    brain_parm.brain_file = get(H.brain_file_edit, 'String');

    % AREA file
    brain_parm.area_file  = get(H.area_file_edit, 'String');

    % fMRI file
    brain_parm.act_file   = get(H.act_file_edit, 'String');
    
    %%%%%%%%%%%%%%%%%%%%
    % execute job
    %%%%%%%%%%%%%%%%%%%%
    set(H.brain_exec_push, 'String', 'Processing...');
    pause(0.01) % button string change
    vb_job_brain(proj_root, brain_parm);
    set(H.brain_exec_push, 'String', 'Exec');

function update_model_type(H)
% This function update screen by model type
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    bv_group = [H.brainvoyager_left_brain_label;
                H.left_edit;
                H.left_push;
                H.brainvoyager_right_brain_label;
                H.right_edit;
                H.right_push;
                H.brainvoyager_left_inf_label;
                H.left_inflate_edit;
                H.left_inflate_push;
                H.brainvoyager_right_inf_label;
                H.right_inflate_edit;
                H.right_inflate_push];

    fs_group = [H.freesurfer_left_brain_label;
                H.freesurfer_left_edit;
                H.freesurfer_left_push;
                H.freesurfer_right_brain_label;
                H.freesurfer_right_edit;
                H.freesurfer_right_push;
                H.freesurfer_left_inflate_label;
                H.freesurfer_left_inflate_edit;
                H.freesurfer_left_inflate_push;
                H.freesurfer_right_inflate_label;
                H.freesurfer_right_inflate_edit;
                H.freesurfer_right_inflate_push;
                H.freesurfer_left_curv_label;
                H.freesurfer_left_curv_edit;
                H.freesurfer_left_curv_push;
                H.freesurfer_right_curv_label;
                H.freesurfer_right_curv_edit;
                H.freesurfer_right_curv_push;];

    common_group = [H.spm_normalization_label;
                    H.spm_normalization_file_edit;
                    H.spm_normalization_file_push];
%                H.freesurfer_left_sphere_label;
%                H.freesurfer_left_sphere_edit;
%                H.freesurfer_left_sphere_push;
%                H.freesurfer_right_sphere_label;
%                H.freesurfer_right_sphere_edit;
%                H.freesurfer_right_sphere_push];

    model_type = 1; % 1 : BrainVoyager, 2:FreeSurfer
    set(H.fs_quick_input_push, 'Visible', 'off');
    if get(H.model_brainvoyager_radiobutton, 'Value')
        model_type = 1;
    elseif get(H.model_freesurfer_radiobutton, 'Value')
        set(H.fs_quick_input_push, 'Visible', 'on');
        model_type = 2;
    else
        error('model type error : pa_brain_util()');
    end

    switch(model_type)
    case 1
        set(bv_group, 'Visible', 'on');
        set(fs_group, 'Visible', 'off');
    case 2
        set(bv_group, 'Visible', 'off');
        set(fs_group, 'Visible', 'on');
    end
    set(common_group, 'Visible', 'on');
