function pa_brain_close(fig)
% This function close brain GUI.
% [USAGE]
%    pa_brain_close(<fig>);
% [IN]
%    fig : figure handle of brain gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

%
% --- Main Procedure
%

% load data(@see pa_brain_create)
data = guidata(fig);

% delete advanced parameter figure.
for k=1:length(data.adv_fig)
    if ishandle(data.adv_fig(k))
        delete(data.adv_fig(k));
    end
end

% delete main figure.
if ishandle(data.H.figure)
    delete(data.H.figure);
end
