function [brain_parm] = pa_brain_parm_gui_get_parm(fig)
% get brain_parm from brain advanced parameter gui.
% [USAGE]
%    brain_parm = pa_brain_parm_gui_get_parm(fig);
% [IN]
%    fig : figure handle of brain advanced parameter gui.
% [OUT]
%    brain_parm : advanced parameter of brain_parm.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('figure handle is invalid.');
end

%
% --- Main Procedure
%
data = guidata(fig);
H = data.H;

% Maximum radius for neighbor search 
r_max = str2num(get(H.rmax_edit, 'String')) / 1000.0;%[mm]->[m]

% Total number of vertices of surface
Nvertex = str2num(get(H.nvertex_edit, 'String'));

% Reduce ratio for surface data
reduce_ratio = str2num(get(H.reduce_ratio_edit, 'String'));

% Division number of z axis in matching between BV and MRI points
n_step = str2num(get(H.nstep_edit, 'String'));

% Display progress for this steps
display = str2num(get(H.display_edit, 'String'));

brain_parm.R_max            = r_max;
brain_parm.Nvertex          = Nvertex;
brain_parm.reduce_ratio     = reduce_ratio;
brain_parm.N_step           = n_step;
brain_parm.display          = display;
