function [fig] = current_gui_new(proj_root, current_parm)
% create current_parm gui.
% [USAGE]
%    fig = current_gui_new([proj_root][,current_parm])
% [IN]
%       proj_root : project root directory
%    current_parm : current parameter
% [OUT]
%    fig : figure handle of current_parm gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end
if ~exist('current_parm', 'var')
    current_parm = vb_set_current_parm;
end

%
% --- Main Procedure
%

fig = openfig('current_gui.fig');
data = struct;
data.H            = guihandles(fig);
data.H.figure     = fig;
data.current_parm = current_parm;
data.time_parm    = [];
data.adv_fig      = -1; % figure handle of advanced parameter gui.

guidata(fig, data);

set(data.H.proj_root_edit, 'String', proj_root);
current_gui(fig, 'set_parm', current_parm);
