function current_gui_delete(fig)
% delete figure of current parameter gui.
% [USAGE]
%    current_gui_delete(fig);
% [IN]
%    fig : figure handle of current_gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var'), error('fig is a required parameter.'); end

%
% --- Main Procedure
%
data = guidata(fig);

% delete advanced parameter figure
for k=1:length(data.adv_fig)
    if ishandle(data.adv_fig(k))
        current_gui_advanced_delete(data.adv_fig(k));
    end
end

delete(fig);
