function current_gui_advanced_set_parm_gui(adv_fig, current_parm)
% set current_parm to gui.
% [USAGE]
%    [adv_fig] = current_gui_advanced_set_parm(adv_fig, current_parm);
% [IN]
%         adv_fig : current_gui_advanced gui figure handle.
%    current_parm : current parameter.
% [OUT]
%    adv_fig : updated current_gui_advanced adv_figect.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('adv_fig', 'var'), error('adv_fig is a required parameter.'); end
if ~exist('current_parm', 'var')
    error('current_parm is a required parameter.');
end

%
% --- Main procedure
%

data = guidata(adv_fig);
H = data.H;

%
% --- Overlap mode
%
if isfield(current_parm, 'overlap_mode')
    if current_parm.overlap_mode == 0
        set(H.overlapped_radiobutton, 'Value', 1);
        set(H.concatenate_radiobutton, 'Value', 0);
    else
        set(H.overlapped_radiobutton, 'Value', 0);
        set(H.concatenate_radiobutton, 'Value', 1);
    end
end


