function [adv_fig] = ...
             current_gui_advanced_new(current_gui_figure, current_parm)
% Advanced parameter view of current_gui created.
% [USAGE]
%    [adv_fig] = current_gui_advanced_new(current_gui_figure [,current_parm]);
% [IN]
%    current_gui_figure : current_gui figure handle
%          current_parm : current_parm
% [OUT]
%    adv_fig : current gui advanced paramter figure
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('current_gui_figure', 'var')
    error('current_gui_figure is a required parameter.');
end

%
% --- Main Procedure
%
if ~exist('current_parm', 'var')
    current_parm = [];
end

%
% --- Open figure and make object member
%
adv_fig = openfig('current_gui_advanced.fig');
set(adv_fig, 'Name', 'current_parm');

% handles
data = struct;
data.H =guihandles(adv_fig);
data.H.figure = adv_fig;
data.parent   = current_gui_figure; % remember parent figure

% save data to figure
guidata(adv_fig, data);

% set parameter to gui
current_gui_advanced_set_parm_gui(adv_fig, current_parm);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
