function [obj] = brain_file_maker_view3d(obj, brain_file, area_file, act_file)
% launch job_view_cortex
% [USAGE]
%    brain_file_maker_view3d(<obj>, <brain_file>, <area_file>, <act_file>);
% [IN]
%           obj : brain_file_maker object
%    brain_file : brain file(.brain.mat) (fullpath)
%     area_file : area file(.area.mat)   (fullpath)
%      act_file : act file(.act.mat)     (fullpath)
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_file', 'var') || exist(brain_file, 'file') ~= 2
    error('brain_file is a required parameter.');
end
if ~exist('area_file', 'var')
    error('area_file is a required parameter.');
end
if ~exist('act_file', 'var')
    error('act_file is a required parameter.');
end

%
% --- Main Procedure
%
vb_act_area_viewer(brain_file, act_file, area_file);
obj.view3d = gcf;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
