function [result, cancelled] = brain_file_maker_make_brainfiles_from_mask_file(...
                                    obj, parm, comment)
% make brain files from mask file
% [USAGE]
%    [result, cancelled] = brain_file_maker_make_brainfiles_from_mask_file(...
%                               <obj>, <parm> [,comment])
% [IN]
%           obj : brain_file_maker object
%          parm : parameter for making brain files.
%       comment : comment
% [OUT]
%       result : <<out>> SUCCESS or FAILURE
%                        (FAILURE is returned when error occurs.)
%    cancelled : <<out>> true or false
%                        (true is returned when select 'Yes' at overwrite confirmation.)
%
% Author: rhayashi
% Created: 2007-07-23
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end
if ~exist('comment', 'var'),
    comment = '';
end

%
% --- Main Procedure
%
global vbmeg_inst;
result = FAILURE;
cancelled = true;

% try
proj_root = obj.proj_root;
parm.comment = comment;
parm.subj_mask = obj.output_mask_file;
parm.analyze_file = ...
    [vb_analyze_info_get_file_prefix(obj.analyze_info), '.hdr'];

parm.brain_file = obj.output_brain_file;
parm.area_file  = obj.output_area_file;
parm.act_file   = obj.output_act_file;

% File overwrite check
if exist([proj_root, filesep, parm.brain_file], 'file') == 2
    res = questdlg('Cortical model file already exists. overwrite?',...
                    'confirm', 'Yes', 'No', 'Yes');
    if strcmp(res, 'No')
        cancelled = true;
        return;
    end
end

h = brain_file_maker_show_wait_dialog;
vb_job_brain_std2sbj(proj_root, parm);
brain_file_maker_delete_wait_dialog(h);

result = SUCCESS;
cancelled = false;

% catch
%     result = FAILURE;
% end
