function [parm, cancelled] = process_parm_editor_edit(obj, parm_type, parm)
% edit parameter by gui and return parameter.
% [USAGE]
%    [parm, cancelled] = process_parm_editor_edit(<obj>, <parm_type>, <parm>);
% [IN]
%          obj : process_parm_editor object
%    parm_type : edit parameter type
%         parm : <<structure>> parameter
% [OUT]
%         parm : <<structure>> parameter
%    cancelled : <<boolean> true/false. true means edit cancelled.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

%
% --- Main Procedure
%
cancelled = false;
const = define_bm_edit_app;
type = const.parm_type;

switch(parm_type)
    case {type.SURF_SMOOTH_PARM, ...
          type.SURF_SMOOTH_EXPAND_PARM, ...
          type.SURF_TO_FILLED_MASK_PARM, ...
          type.MORPHOLOGY_OPERATION_PARM, ...
          type.SURF_EXTRACT_PARM}

        [parm, cancelled] = vb_edit_struct(parm);
    case {type.SEPARATE_SURF_PARM, ...
          type.COMBINE_SURF_PARM, ...
          type.CLOSE_SURF_PARM}
        % Thru
end

pause(0.1);
