function [obj] = surf_data_new(V, F, xx, coord_type, model_name, conductivity)
% create surf_data object
% [USAGE]
%    [obj] = surf_data_new(
%               <V>, <F>, <xx>, <coord_type>[,model_name][,conductivity]);
% [IN]
%               V : vertex
%               F : face
%              xx : normal vector
%      coord_type : coordinate type of surf_data
%      model_name : model name of surf_data
%    conductivity : conductivity value
% [OUT]
%    obj : surf_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


const = define_bm_edit_app;

%
% --- Previous check
%
if ~exist('V', 'var'), error('V is a required parameter.'); end
if ~exist('F', 'var'), error('F is a required parameter.'); end
if ~exist('xx', 'var'), error('xx is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end
if ~exist('model_name', 'var') || isempty(model_name)
    model_name = 'surface model';
end
if ~exist('conductivity', 'var') || isempty(conductivity)
    conductivity = const.DEFAULT_CONDUCTIVITY;
end

%
% --- Inheritance
%
obj = brain_data_new(coord_type, model_name, conductivity);

% set class type
obj.class_type = 'surf_data';

%
% --- Main Procedure
%


obj.V = V;
obj.F = F;
obj.xx = xx;

% surface close status
omega = vb_solid_angle_check(V, F);
if abs(omega-1)>1e-10
    obj.status = const.surf_status.SURFACE_NOT_CLOSED;
else
    obj.status = const.surf_status.SURFACE_CLOSED;
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
