function [obj] = bm_view_parm2d_set_color(obj, color)
% set color setting
% [USAGE]
%    [obj] = bm_view_parm2d_set_color(<obj>, <color>);
% [IN]
%      obj : bm_view_parm2d object
%    color : Color setting for plot function.
%            (e.g. { 'y-' , 'r-' , 'c-' , 'g-' , 'w-', 'm-'})
% [OUT]
%    obj : bm_view_parm2d object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('color', 'var'), error('color is a required parameter.'); end

%
% --- Main Procedure
%
obj.color = color;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
