function [obj] = bm_view_parm2d_set_analyze_file(obj, analyze_file)
% set analyze_file to setting object
% [USAGE]
%    [obj] = bm_view_parm2d_set_analyze_file(<obj>, <analyze_file>);
% [IN]
%             obj : bm_view_parm2d object
%    analyze_file : analyze file(absolute)
% [OUT]
%    obj : bm_view_parm2d object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('analyze_file', 'var')
    error('analyze_file is a required parameter.');
end

%
% --- Main Procedure
%
obj.analyze_file = analyze_file;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
