function [obj] = bm_processor_set_analyze_info(obj, analyze_info)
% set analyze_info to this class
% [USAGE]
%    [obj] = bm_processor_set_analyze_info(<obj>, <analyze_info>);
% [IN]
%             obj : bm_processor object
%    analyze_info : analyze_info object
% [OUT]
%    obj : bm_processor object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('analyze_info', 'var')
    error('analyze_info is a required parameter.');
end

%
% --- Main Procedure
%
obj.analyze_info = analyze_info;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
