function [parm] = bm_manager_get_process_parameter(obj, parm_type)
% get specified parameter.
% [USAGE]
%    [parm] = bm_manager_get_process_parameter(<obj>, <parm_type>);
% [IN]
%          obj : bm_manager object
%    parm_type : parameter type
% [OUT]
%    parm : <<struct>> parameter
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%
parm = bm_process_parm_list_get_parameter(obj.parm_list, parm_type);
