function [model_name_cell] = bm_manager_get_model_name(obj, index)
% get brain model info(model name and processing history)
% [USAGE]
%    [model_name_cell] = bm_manager_get_model_name(<obj>, <index>);
% [IN]
%      obj : bm_manager object
%    index : brain model list index(Nx1)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('index', 'var'), error('index is a required parameter.'); end

%
% --- Main Procedure
%
brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);

% allocate values to return
Nmodel = length(brain_data_cell);
model_name_cell   = cell(Nmodel, 1);

for k=1:Nmodel
    % get model info
    model_name   = brain_data_get_model_name(brain_data_cell{k});
    % set model info to return value
    model_name_cell{k}   = model_name;
end
