function [obj, index] = bm_list_overwrite_model(obj, brain_data, index_no)
% overwrite brain_data.
% [USAGE]
%    [obj, index] = bm_list_overwrite_model(<obj>, <brain_data>, <index_no>);
% [IN]
%           obj : bm_list object
%    brain_data : brain_data object
%      index_no : overwritten index number(scalar)
% [OUT]
%      obj : bm_list object
%    index : bm_list index
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~strcmp(obj.class_type, 'bm_list')
    error('class type is invalid.');
end
if ~exist('index_no', 'var')
    error('index_no is a required parameter.');
end

% index range check
index = bm_list_get_brain_model_index(obj);
if isempty(find(index == index_no ))
    error('specified index_no is invalid.');
end

%
% --- Main Procedure
%
obj.brain_data_list{index_no} = brain_data;

%
% --- After check
%
if nargout == 0
    error('function caller should receive obj.');
end
