function [index] = bm_list_get_brain_model_index(obj)
% get brain model index
% [USAGE]
%    [index] = bm_list_get_brain_model_index(<obj>);
% [IN]
%    obj : bm_list object
% [OUT]
%    index : index of bm_list object has. (Nx1)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_list')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
index = [1:1:length(obj.brain_data_list)];
