function [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] = ...
                bm_fileio_read_head_file(file_name)
% read head file.
% [USAGE]
%    [V_cell, F_cell, xx_cell] = bm_fileio_read_head_file(<file_name>);
% [IN]
%    file_name : full path head file name(.head.mat)
% [OUT]
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity value
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('file_name', 'var')
    error('file_name is a required parameter.');
end
if exist(file_name, 'file') ~= 2
    error(['specified head file does not exist : ' file_name]);
end

%
% --- Main Procedure
%
V_cell = cell(0);
F_cell = cell(0);
xx_cell = cell(0);
model_name_cell = cell(0);
conduct_cell = cell(0);

Nlayer = vb_head_get_layer_num(file_name);
for k=1:Nlayer
    [HeadInfo] = vb_head_get_specified_headinfo(file_name, k);
    V_cell{k} = vb_headinfo_get_vhead(HeadInfo);
    F_cell{k} = vb_headinfo_get_fhead(HeadInfo);
    xx_cell{k} = vb_headinfo_get_xxhead(HeadInfo);
    conduct_cell{k} = vb_headinfo_get_sigma(HeadInfo);

    model_name_cell{k} = vb_headinfo_get_layertag(HeadInfo);
    if isempty(model_name_cell{k})
        model_name_cell{k} = ['brain model', num2str(k)];
    end
end
