function [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] = ...
                bm_fileio_read_face_file(file_name)
% read brain file.
% [USAGE]
%    [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] ...
%             = bm_fileio_read_face_file(<file_name>);
% [IN]
%    file_name : full path brain file(.brain.mat)
% [OUT]
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('file_name', 'var')
    error('file_name is a required parameter.');
end
if exist(file_name, 'file') ~= 2
    error(['specified brain file does not exist : ' file_name]);
end

%
% --- Main Procedure
%
const = define_bm_edit_app;

load(file_name, 'surf_face');

[F, V] = vb_reducepatch(surf_face.F, surf_face.V, 10000);
V_cell{1}  = V;
[xx_cell{1} ,F_cell{1}] = vb_out_normal_vect(V,F);
conduct_cell{1} = const.DEFAULT_CONDUCTIVITY;

model_name_cell{1} = 'Face';
