function h = bm_edit_app_view3d_plot_surf(...
                            obj, axes_h, V, F, face_color, alpha, max_mode)
% plot surface
% [USAGE]
%    h = bm_edit_app_view3d_plot_surf(...
%                         <obj>, <V>, <F>[, face_color][, max_mode]);
% [IN]
%           obj : bm_edit_app_view3d object
%        axes_h : plotted axes handle
%             V : vertex coordinate
%             F : patch index
%    face_color : face color
%         alpha : face alpha
%      max_mode : set axis limit
% [OUT]
%    h : patch object handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('axes_h', 'var'), error('axes_h is a required parameter.'); end
if ~exist('V', 'var'), error('V is a required parameter.'); end
if ~exist('F', 'var'), error('F is a required parameter.'); end
if ~exist('face_color','var') | isempty(face_color), 
    face_color = [0.8 0.7 0.6];
end
if ~exist('alpha', 'var')
    alpha = 0.9;
end
if ~exist('max_mode','var') | isempty(max_mode), max_mode=0; end;

%
% --- Main Procedure
%

set(gcf, 'CurrentAxes', axes_h);

% ɽ
h = patch('Faces',F,'Vertices',V,'FaceColor',face_color,'EdgeColor','none', 'FaceAlpha', alpha);

lighting phong;
material dull;
axis equal;

xlabel('X');
ylabel('Y');
zlabel('Z');

if  max_mode == 1
    Vmax = max(V);
    Vmin = min(V);
    xlim([Vmin(1) Vmax(1)]);
    ylim([Vmin(2) Vmax(2)]);
    zlim([Vmin(3) Vmax(3)]);
end
